#version 330 core

uniform mat4 mvpMatrix;
uniform mat4 modelMatrix;
uniform mat4 modelviewMatrix;
uniform float uniTime;

uniform vec3 ViewPos;
uniform vec3 LightPos;

layout (location = 0) in vec3 pos;
layout (location = 2) in vec2 texCoords;
 
out vec2 texturecoords;
out float time;
out vec4 worldPos;
out vec4 viewSpacePos;

out vec3 viewPosTangient;
out vec3 lightPosTangient;

//vielleicht den tangient space hier ausrechnen!
//http://learnopengl.com/#!Advanced-Lighting/Normal-Mapping

void main()
{
	gl_Position = mvpMatrix * vec4(pos,1);
 
	viewSpacePos = mvpMatrix * vec4(pos,1);
worldPos = modelMatrix * vec4(pos,1);
	texturecoords = texCoords;
	time = uniTime / 100;


vec3 facenormal = normalize(vec3(0.0,1.0,0.0));
vec3 up = vec3(0.0,1.0,0.0);
vec3 tangent = normalize(cross(up, facenormal));
if(length(tangent) == 0)
	tangent = vec3(1, 0, 0);
vec3 bitangent = normalize(cross(facenormal, tangent));

mat3 tbnMatrix = transpose(mat3(tangent, bitangent, facenormal));

worldPos = vec4(tbnMatrix * worldPos.xyz,1);
viewPosTangient = tbnMatrix * ViewPos;
lightPosTangient = tbnMatrix * LightPos;

}