#version 330 core

layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 uv;

uniform mat4 depthMVP;
uniform mat4 model;
uniform mat4 view_project;
uniform mat4 lightViewProj;

out vec4 smCoords;
out vec2 fragmentUV;
out vec3 worldNormal;
out vec3 worldPosition;
out vec4 fragmentPositionInLightSpace;

void main(void){
	gl_Position = view_project * model * vec4(position, 1);
	smCoords = depthMVP * vec4(position, 1);

	fragmentUV = uv;

	//world space transformation
	worldPosition = (model * vec4(position, 1)).xyz;
	worldNormal = mat3(transpose(inverse(model))) * normal;

	fragmentPositionInLightSpace = lightViewProj * vec4(worldPosition, 1.0) ;
}