#version 330

layout(points) in;
layout(points) out;
layout(max_vertices = 60) out;

in vec3 vPosition[];
in vec3 vVelocity[];
in float vAge[];
in float vType[];

uniform float dT;
uniform float gShellLifetime;
uniform float gTime;
uniform sampler1D gRandomTexture;

out vec3 gPosition;
out vec3 gVelocity;
out float gAge;
out float gType;

#define PARTICLE_LAUNCHER 0.0f
#define PARTICLE_SHELL 1.0f

vec3 randomDirection(float uv)
{
	vec3 res = texture(gRandomTexture, uv).xyz;
	res -= vec3(0.5, 0.5, 0.5);
	return res;
}

void main(void)
{
	vec3 position = vPosition[0];
	vec3 velocity = vVelocity[0];
	float type = vType[0];
	float age = vAge[0] + dT;

	if(type == PARTICLE_LAUNCHER)
	{
		gPosition = position;
		gVelocity = velocity;
		gType = PARTICLE_LAUNCHER;
		gAge = 0.0;

		EmitVertex();
		EndPrimitive();

		for (int i = 0; i < 30; i++)
		{
			gPosition = position;

			vec3 randDirection = randomDirection(gTime/1000.0);
			randDirection.y = max(randDirection.y, 0.5);
			gVelocity = normalize(randDirection);
			
			gType = PARTICLE_SHELL;
			gAge = 0.0f;

			EmitVertex();
			EndPrimitive();
		}
	}
	else if(age < gShellLifetime)
	{
		gPosition = position + velocity * dT * 4;
		gVelocity = velocity;
		gType = type;
		gAge = age;

		EmitVertex();
		EndPrimitive();
	}
}