#version 330 core

layout(triangles) in;
layout(triangle_strip, max_vertices=18) out;

uniform mat4 shadowMatrices[6];

out vec4 fragPosition;

void main(){
	for(gl_Layer=0; gl_Layer<6; ++gl_Layer)
	{
		for(int i = 0; i < 3; ++i)
		{
			fragPosition = gl_in[i].gl_Position;
			gl_Position = shadowMatrices[gl_Layer] * fragPosition;
			EmitVertex();
		}
		EndPrimitive();
	}
}