#version 330 core

layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 uv;

out vec3 worldPosition;
out vec3 worldNormal;

uniform mat4 model;
uniform mat4 view_project;

void main()
{
    gl_Position = view_project * model * vec4(position, 1);

	//world space transformation
	worldPosition = (model * vec4(position, 1)).xyz;
	worldNormal = mat3(transpose(inverse(model))) * normal;
} 