#version 330 core

in vec3 worldNormal;
in vec3 worldPosition;

out vec4 outColor;

uniform vec3 worldCameraPosition;
uniform samplerCube skybox;

void main()
{    
    vec3 I = normalize(worldPosition - worldCameraPosition);
	vec3 R = reflect(I, normalize(worldNormal));
	outColor = texture(skybox,R);
}