#version 330

layout(points) in;
layout(triangle_strip) out;
layout(max_vertices = 4) out;

uniform mat4 gViewProject;
uniform vec3 gCameraPosition;
uniform float gBillboardSize;

out vec2 gUV;

void main()
{
	vec3 position = gl_in[0].gl_Position.xyz;
	vec3 toCamera = normalize(gCameraPosition - position);
	vec3 up = vec3(0.0, 1.0, 0.0);
	vec3 right = cross(toCamera, up) * gBillboardSize;

	position -= right;
	gl_Position = gViewProject * vec4(position, 1.0);
	gUV = vec2(0.0, 0.0);
	EmitVertex();

	position.y += gBillboardSize;
	gl_Position = gViewProject * vec4(position, 1.0);
	gUV = vec2(0.0, 1.0);
	EmitVertex();

	position.y -= gBillboardSize;
	position += right;
	gl_Position = gViewProject * vec4(position, 1.0);
	gUV = vec2(1.0, 0.0);
	EmitVertex();

	position.y += gBillboardSize;
	gl_Position = gViewProject * vec4(position, 1.0);
	gUV = vec2(1.0, 1.0);
	EmitVertex();

	EndPrimitive();
}