#version 330 core

in vec3 position;
in vec3 normal;
in vec2 uv;

uniform mat4 model;
uniform mat4 view_project;

out vec3 worldNormal;
out vec3 worldPosition;
out vec2 fragmentUV;

void main(){
	fragmentUV = uv;

	//projection space transformation
	gl_Position = view_project * model * vec4(position, 1);

	//world space transformation
	worldPosition = (model * vec4(position, 0)).xyz;
	worldNormal = (model * vec4(normal,0)).xyz; 

}