#version 330 core

in vec3 worldNormal;
in vec3 worldPosition;
in vec2 fragmentUV;

layout(location=0) out vec4 outColor;

uniform sampler2D textureSampler;
uniform float matSpecExponent;
uniform vec3 worldLightPosition;
uniform vec3 lightIntensity;

void main(){
	//Calculate intensity based on Lambert model
	vec3 lightDirection = normalize(worldLightPosition - worldPosition);
	vec3 lightIntensity = vec3(1,1,1); 
	vec3 textureColor = texture(textureSampler, fragmentUV).rgb;

	//normalize world normal to get the angle from the dot product
	vec3 n = normalize(worldNormal);

	//calculate dot product and get angle
	//clamp result to make sure we don't have negative colors
	float nDotL = clamp(dot(n, lightDirection), 0, 1);

	//add a little ambient color to make it more interesting
	vec3 textureAmbientColor = vec3(0.1,0.1,0.1) * textureColor;

	//outColor = vec4(textureColor, 1.0);
	outColor = vec4(textureAmbientColor + textureColor * nDotL * lightIntensity, 1.0);
}