#include <iostream>
#include <sstream>
#include <GL\glew.h>
#include <GL\GL.h>
#include <GLFW\glfw3.h>

#include "Loop/WindowCreator.hpp"
#include "Loop/LoopHelper.hpp"
#include "Loop/DebugContext.hpp"
#include "Loop/InputHandler.hpp"
#include "Loop/SoundHandler.hpp"


using namespace cgue::util;
using namespace cgue::scene;
using namespace cgue::loop;
using namespace cgue::loader;



int main(int argc, char** argv) {
	DebugContext* debugContext = nullptr;// = new DebugContext();
	WindowCreator* windowCreator = new WindowCreator(argc, argv);
	GLFWwindow* window = windowCreator->create(&debugContext);
	
	debugContext->registerDebugCallback();


	SoundHandler* soundHandler = new SoundHandler();
	LoopHelper* loopHelper = new LoopHelper(window, soundHandler);
	InputHandler* inputHandler = new InputHandler(window, loopHelper, soundHandler);
	ShaderLoader* shaderLoader = new ShaderLoader();

	// init window
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE); // Cull triangles which normal is not towards the camera
	

	glClearColor(0.1f, 0.1f, 0.1f, 1.0f); // clear buffers
	int width, height;
	glfwGetFramebufferSize(window, &width, &height);
	glViewport(0, 0, width, height);

	//framerate values
	double last_time = 0.0;
	double cur_time = 0.0;
	double time_delta = 0.0;


	// close window on ESC key
	while (!glfwGetKey(window, GLFW_KEY_ESCAPE) && !glfwWindowShouldClose(window)) {

		// clear frame and depth buffer
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

		// compute framerate - time difference between current and last frame
		cur_time = glfwGetTime();
		time_delta = cur_time - last_time;	// multiply motion by time_delta (provide everything in units / second)
		last_time = cur_time;				// For the next frame, the "last time" will be "now"
		

		// react to user input
		glfwPollEvents();

		// update and render scene
		inputHandler->processKeyboardInput(time_delta);
		loopHelper->update(time_delta);
		loopHelper->draw();

		if (loopHelper->gameLogic->isGameOver() || loopHelper->gameLogic->isGameWon()) {
			inputHandler->gameRunning = false;
		}

		glfwSwapBuffers(window);
	}
	window = nullptr;
	delete loopHelper; loopHelper = nullptr;
	delete soundHandler; soundHandler = nullptr;
	delete windowCreator; windowCreator = nullptr;
	delete debugContext; debugContext = nullptr;

	glfwTerminate();

	return EXIT_SUCCESS;
}