#pragma once

#include <string>
#include <GL\glew.h>
#include <GLFW\glfw3.h>

namespace cgue {
	namespace util {
		class Shader {
		public:
			Shader(const std::string & vertexShader, const std::string& fragmentShader);
			~Shader();

			void useShader() const;

			GLuint programHandle;
			GLuint vertexHandle;
			GLuint fragmentHandle;

		private:

			//handle = output parameter
			void loadShader(const std::string& shader, GLenum shaderType, GLuint& handle);
			void link();	//combines the shaders to a program

			
		};
	}
}