#include "Shader.hpp"

#include <iostream>
#include <fstream>

using namespace cgue::util;
using namespace std;

Shader::Shader(const std::string & vertexShader, const std::string& fragmentShader)
: programHandle(0), vertexHandle(0), fragmentHandle(0) {	//Initializer list 

	programHandle = glCreateProgram();

	if (programHandle == 0) {
		std::cout << "Error: Could not create program" << std::endl;
		system("PAUSE");
		exit(EXIT_FAILURE);
	}

	//Handle parameter used as output parameter
	loadShader(vertexShader, GL_VERTEX_SHADER, vertexHandle);
	loadShader(fragmentShader, GL_FRAGMENT_SHADER, fragmentHandle);

	link();

}

Shader::~Shader() {
	glDeleteProgram(programHandle);
	glDeleteShader(vertexHandle);
	glDeleteShader(fragmentHandle);
}

void Shader::useShader() const {

	glUseProgram(programHandle);

}

void Shader::loadShader(const std::string& shader, GLenum shaderType, GLuint& handle) {

	std::ifstream shaderFile(shader);

	if (!shaderFile.good()) {
		std::cout << "Error: Could not load shader file " << shader << std::endl;
		system("PAUSE");
		exit(EXIT_FAILURE);
	}

	//load shader from file into code
	std::string code = std::string(
		std::istreambuf_iterator<char>(shaderFile),
		std::istreambuf_iterator<char>());

	shaderFile.close();

	handle = glCreateShader(shaderType);

	if (handle == 0) {
		std::cout << "Error: Could not create shader" << std::endl;
		exit(EXIT_FAILURE);
	}

	const char * codePtr = code.c_str();
	glShaderSource(handle, 1, &codePtr, nullptr);
	glCompileShader(handle);

	//check if shader got successfully created
	GLint suceeded;
	glGetShaderiv(handle, GL_COMPILE_STATUS, &suceeded);

	if (!suceeded) {
		GLint logSize;
		glGetShaderiv(handle, GL_INFO_LOG_LENGTH, &logSize);

		GLchar* msg = new GLchar[logSize];

		glGetShaderInfoLog(handle, logSize, nullptr, msg);

		std::cout << msg << std::endl;

		delete[] msg;
		system("PAUSE");
		exit(EXIT_FAILURE);
	}

}

void Shader::link() {
	glAttachShader(programHandle, vertexHandle);
	glAttachShader(programHandle, fragmentHandle);

	glLinkProgram(programHandle);

	//check if program linking was successful
	GLint suceeded;
	glGetProgramiv(programHandle, GL_LINK_STATUS, &suceeded);

	if (!suceeded) {
		GLint logSize;
		glGetProgramiv(programHandle, GL_INFO_LOG_LENGTH, &logSize);

		GLchar* msg = new GLchar[logSize];

		glGetProgramInfoLog(programHandle, logSize, nullptr, msg);

		std::cout << msg << std::endl;

		delete[] msg;

		exit(EXIT_FAILURE);
	}

}