#pragma once

#include <ft2build.h>
#include FT_FREETYPE_H  
#include FT_STROKER_H

#include <iostream>
#include <sstream>
#include <glm/glm.hpp>
#include <vector>
#include "../Util/shader.hpp"
#include <map>
#include <glm/gtc/matrix_transform.hpp> 
#include <glm/gtc/type_ptr.hpp>

namespace cgue {
	namespace scene {
		/// Holds all state information relevant to a character as loaded using FreeType
		struct Character {
			GLuint TextureID;   // ID handle of the glyph texture
			glm::ivec2 Size;    // Size of glyph
			glm::ivec2 Bearing; // Offset from baseline to left/top of glyph
			GLuint Advance;     // Horizontal offset to advance to next glyph
		};

		class Text {

		public:
			Text(util::Shader* _shader, int width, int height);
			virtual ~Text();

			/**
			* Renders text to the screen.
			*
			* Parameters:
			*  - x distance to the left side of the screen. Values from 0 to 1
			*  - y distance to the top side of the screen. Values form 0 to 1
			*/
			void draw(std::string text, float x, float y);

			GLfloat scale;
			glm::vec4 color;

		private:
			void load();

			std::map<GLchar, Character> characters;
			util::Shader* shader;
			FT_Face face;
			FT_Library ftLib;
			FT_Stroker stroker;

			GLuint VAO;
			GLuint VBO;

			int width;
			int height;

			glm::mat4 projection;
		};
	}
}