#pragma once

#include <glm/glm.hpp>
#include <vector>

#include <FreeImage\FreeImage.h>
#include "../Util/Shader.hpp"
#include "Camera.hpp"

namespace cgue {
	namespace scene {
		class SkyBox {
		public:
			SkyBox(util::Shader* _shader);
			virtual ~SkyBox();
			void draw();

			GLuint getCubemapTexture();
			GLuint getVAO();
			void bindToTexture();

			void setSamplingQuality(int minQuality, int magQuality);


		private:
			util::Shader* shader;
			glm::mat4 model;

			GLuint vao;
			GLuint vbo;
			GLuint cubemapTexture;

			static const float positions[36 * 3];

			GLuint loadCubemap(std::vector<std::string> faces);
		};
	}
}