//reference: http://learnopengl.com/#!Advanced-OpenGL/Framebuffers

#pragma once

#include <glm/glm.hpp>
#include <glm/gtc/matrix_transform.hpp>
#include <glm/gtc/type_ptr.hpp>
#include <iostream>
#include "../Util/Shader.hpp"
#include "../Loader/ShaderLoader.hpp"
#define S_QUAD_VERTEX_COUNT 24

namespace cgue {
	namespace scene {
		class ShadowMapBuffer {
		public:
			ShadowMapBuffer(util::Shader* _shader, int _screenWidth, int _sreenHeight);
			virtual ~ShadowMapBuffer();

			void bind();
			void draw();
			void unbind();
			void unbindAndDraw();
			void activateTexture();
			void deactivateTexture();
		private:

			util::Shader* shader;
			int screenWidth, screenHeight;
			int shadowWidth, shadowHeight;
			GLuint vao, vbo, fbo, depthMap;

			static const GLfloat quadVertices[S_QUAD_VERTEX_COUNT];

			void init();


		};
	}
}