#pragma once

#define SCENE_OBJECT	//TODO: I don't know what this does

#include <glm/glm.hpp>
#include <vector>
#include "../Util/shader.hpp"
namespace cgue {
	namespace scene {
		//abstract class
		enum Direction{ LEFT, RIGHT, UP, DOWN };
		enum ObjectType{ GOOD, BAD, HERO, PATH, ENVIRONMENT, BONUS1, BONUS2 };

		class SceneObject {

		public:
			SceneObject(glm::mat4&
				Matrix, ObjectType objectType);

			virtual ~SceneObject();

			virtual void draw() = 0;	//= 0 virtual method
			virtual void drawCustomShader(util::Shader* customshader) = 0;
			virtual void update(float time_delta) = 0;

			void rotate(Direction dir, const float& degree);
			virtual void translate(glm::highp_vec3 v);
			void scale(glm::highp_vec3 v);
			glm::vec3 position();
			bool detectHit(SceneObject* other);
			bool detectFrontHit(SceneObject* other);

			glm::mat4 modelMatrix;
			glm::mat4 rotationMatrix;

			float scaleFactor;
			float radius;
			float height;
			ObjectType objectType;
			bool glowing;

			virtual void setSamplingQuality(int minQuality, int magQuality) = 0;
			virtual void changeNormalMapping() = 0;
		};
	}
}