/*//references:	http://www.learnopengl.com/#!Model-Loading/Mesh

*/

#pragma once
#include <iostream>
#include <vector>
#include <string>

#include <glm/glm.hpp>
#include <glm/gtc/matrix_transform.hpp>
#include <glm\gtc\type_ptr.hpp>
#include <GL/glew.h>
#include <GLFW/glfw3.h>
#include <assimp/Importer.hpp>
#include <assimp/scene.h>
#include <assimp/mesh.h>
#include <assimp/postprocess.h>
#include <FreeImage\FreeImage.h>

#include "SceneObject.hpp"
#include "Mesh.hpp"
#include "../Util/shader.hpp"
#include "Light.hpp"

namespace cgue {
	namespace scene {

		class Model : public SceneObject {
		public:
			Model(glm::mat4& _modelMatrix, ObjectType _objectType, util::Shader* _shader,
				GLchar* path);
			virtual ~Model();

			virtual void draw();
			virtual void drawCustomShader(util::Shader* customshader);
			virtual void update(float time_delta);
			virtual void setSamplingQuality(int minQuality, int magQuality);
			virtual void changeNormalMapping();

			void setLight(Light* _light);
		private:
			util::Shader *shader, *customshader;
			Light *light;
			glm::vec3 lightPos;
			glm::vec3 lightColor;
			bool normalMapping;

			/*  Model Data  */
			std::vector<mesh::Mesh*> meshes;
			std::vector<mesh::Texture> textures_loaded;
			std::string directory;

			/*  Functions   */
			void initModel(const std::string& path);
			void processNode(aiNode* node, const aiScene* scene);
			mesh::Mesh *processMesh(aiMesh* mesh, const aiScene* scene);
			std::vector<mesh::Texture> loadMaterialTextures(aiMaterial* mat, aiTextureType type, std::string typeName);
			GLint TextureFromFile(const char* path, std::string directory);
		};

	}
}