/*references:	http://www.nexcius.net/2014/04/13/loading-meshes-using-assimp-in-opengl/
http://www.learnopengl.com/#!Model-Loading/Mesh
*/

#pragma once
#include <iostream>
#include <sstream>
#include <vector>
#include <string>

#include <glm/glm.hpp>
#include <glm/gtc/matrix_transform.hpp>
#include <glm/gtc/type_ptr.hpp>
#include <GL/glew.h>
#include <GLFW/glfw3.h>
#include <assimp/scene.h>
#include <assimp/mesh.h>
#include <assimp/Importer.hpp>
#include <assimp/postprocess.h>

#include "Sceneobject.hpp"
#include "Light.hpp"
#include "../Util/shader.hpp"

namespace cgue{
	namespace scene{
		namespace mesh {
			struct Vertex {
				glm::vec3 Position;
				glm::vec3 Normal;
				glm::vec2 TexCoords;
				glm::vec3 Tangent;
				//glm::vec3 Bitangent;
			};
			struct Texture {
				GLuint id;
				std::string type;
				aiString path;
			};

			class Mesh {

			public:
				/*  Mesh Data  */
				std::vector<Vertex> vertices;
				std::vector<GLuint> indices;
				std::vector<Texture> textures;

				/*  Functions  */
				Mesh(util::Shader* _shader, std::vector<Vertex> _vertices, std::vector<GLuint> _indices, std::vector<Texture> _textures);
				virtual ~Mesh();

				//void update(float time_delta);
				void draw();
				void setShader(util::Shader* _shader);
			private:
				/*  Render data  */
				//Vertex Array Objects, Vertex Buffer Objects, Element Buffer Objects
				GLuint vao, vbo, ebo;

				util::Shader *shader;
				/*  Functions    */
				void initMesh();
			};
		}
	}
}