/*reference: http://www.learnopengl.com/#!Model-Loading/Mesh */

#include "Mesh.hpp"

using namespace cgue;
using namespace cgue::scene;
using namespace cgue::scene::mesh;

Mesh::Mesh(util::Shader* _shader, std::vector<Vertex> _vertices, std::vector<GLuint> _indices, std::vector<Texture> _textures)
:shader(_shader), vertices(_vertices), indices(_indices), textures(_textures) {

	initMesh();

}
Mesh::~Mesh() {
	glDeleteBuffers(1, &vbo);
	glDeleteBuffers(1, &ebo);
	glDeleteBuffers(1, &vao);

	glDeleteVertexArrays(1, &vao);
}
void Mesh::initMesh() {


	//vertex buffer objects
	glGenBuffers(1, &vbo);
	glBindBuffer(GL_ARRAY_BUFFER, vbo);
	glBufferData(GL_ARRAY_BUFFER, this->vertices.size() * sizeof(Vertex), &this->vertices[0], GL_STATIC_DRAW);
	glBindBuffer(GL_ARRAY_BUFFER, 0);

	//element buffer objects
	glGenBuffers(1, &ebo);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, ebo);
	glBufferData(GL_ELEMENT_ARRAY_BUFFER, this->indices.size() * sizeof(GLuint), &this->indices[0], GL_STATIC_DRAW);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);

	//vertex array objects
	//generate binding
	glGenVertexArrays(1, &vao);
	glBindVertexArray(vao);

	glBindBuffer(GL_ARRAY_BUFFER, vbo);

	//glBindBuffer(GL_ARRAY_BUFFER, vao);
	GLint positionIndex = glGetAttribLocation(shader->programHandle, "position");
	if (positionIndex == -1){
		std::cout << "Error: shader could not load position" << std::endl;
		system("PAUSE");
		exit(EXIT_FAILURE);
	}
	glEnableVertexAttribArray(positionIndex);
	glVertexAttribPointer(positionIndex, 3, GL_FLOAT, GL_FALSE, sizeof(Vertex), (GLvoid*)0);

	//binding normal buffer
	//glBindBuffer(GL_ARRAY_BUFFER, ebo);
	GLint normalIndex = glGetAttribLocation(shader->programHandle, "normal");
	if (normalIndex != -1){
		glEnableVertexAttribArray(normalIndex);
		glVertexAttribPointer(normalIndex, 3, GL_FLOAT, GL_FALSE, sizeof(Vertex), (GLvoid*)offsetof(Vertex, Normal));
	}
	else {
	std::cout << "Error: shader could not load normals" << std::endl;
	system("PAUSE");
	exit(EXIT_FAILURE);
	}


	GLint textureIndex = glGetAttribLocation(shader->programHandle, "texCoords");
	if (textureIndex != -1) {
		glEnableVertexAttribArray(textureIndex);
		glVertexAttribPointer(textureIndex, 2, GL_FLOAT, GL_FALSE, sizeof(Vertex), (GLvoid*)offsetof(Vertex, TexCoords));
	}


	GLint tangentIndex = glGetAttribLocation(shader->programHandle, "tangent");
	if (tangentIndex != -1) {
		glEnableVertexAttribArray(tangentIndex);
		glVertexAttribPointer(tangentIndex, 3, GL_FLOAT, GL_FALSE, sizeof(Vertex), (GLvoid*)offsetof(Vertex, Tangent));
	}

	/*GLint bitangentIndex = glGetAttribLocation(shader->programHandle, "bitangent");
	if (bitangentIndex != -1) {
		glEnableVertexAttribArray(bitangentIndex);
		glVertexAttribPointer(tangentIndex, 3, GL_FLOAT, GL_FALSE, sizeof(Vertex), (GLvoid*)offsetof(Vertex, Bitangent));
	}*/


	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, ebo);




	//unbind
	glBindVertexArray(0);
	glBindBuffer(GL_ARRAY_BUFFER, 0);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);
}

void Mesh::draw() {
	shader->useShader();

	GLuint diffuseNr = 1;
	GLuint specularNr = 1;
	GLuint normalNr = 1;

	for (GLuint i = 0; i < this->textures.size(); i++)
	{
		glActiveTexture(GL_TEXTURE0 + i); // Activate proper texture unit before binding

		// Retrieve texture number (the N in diffuse_textureN)
		std::stringstream ss;
		std::string number;
		std::string name = this->textures[i].type;

		if (name == "texture_diffuse")
			ss << diffuseNr++; // Transfer GLuint to stream
		else if (name == "texture_specular")
			ss << specularNr++; // Transfer GLuint to stream
		else if (name == "texture_normal")
			ss << normalNr++; // Transfer GLuint to stream

		number = ss.str();

		GLuint mat_location = glGetUniformLocation(shader->programHandle, ("material." + name + number).c_str());
		glUniform1i(mat_location, i);	//was glUniform1f
		//glUniform1i(glGetUniformLocation(shader->programHandle, ("material." + name + number).c_str()), i);

		glBindTexture(GL_TEXTURE_2D, this->textures[i].id);
	}
	GLuint matShininess_location = glGetUniformLocation(shader->programHandle, "material.shininess");
	glUniform1f(matShininess_location, 40.0f);
	//glUniform1f(glGetUniformLocation(shader->programHandle, "material.shininess"), 16.0f);
	//glActiveTexture(GL_TEXTURE0);

	glBindVertexArray(vao);
	glDrawElements(GL_TRIANGLES, indices.size(), GL_UNSIGNED_INT, 0);
	glBindVertexArray(0);

	for (GLuint i = 0; i < textures.size(); i++) {
		glActiveTexture(GL_TEXTURE0 + i);
		glBindTexture(GL_TEXTURE_2D, 0);
	}



}

void Mesh::setShader(util::Shader* _shader) {
	this->shader = _shader;
}