#pragma once

#include <glm/glm.hpp>
#include <glm\gtc\matrix_transform.hpp>

#include "SceneObject.hpp"
#include "../Util/shader.hpp"

//don't use these in later project, this is just for testing
#define CUBE_VERTEX_COUNT 24 //not 8 because of normalBuffer instead of indexBuffer
#define CUBE_INDEX_COUNT 36	//6 sides, 2 triangles per side, 3 indices per triangle

namespace cgue {
	namespace scene {

		class Light : public SceneObject {
		public:
			Light(glm::mat4& _modelMatrix, ObjectType _objectType, util::Shader* _shader);

			virtual ~Light();

			virtual void draw();
			virtual void drawCustomShader(util::Shader* customshader);
			virtual void update(float time_delta);
			virtual void setSamplingQuality(int minQuality, int magQuality);
			virtual void changeNormalMapping();

			void setColor(glm::vec3 _lightColor);
			glm::vec3 getLightPos();
			glm::vec3 getLightColor();
			void setLightDir(glm::vec3 _lightDir);
			glm::vec3 getLightDir();

		private:
			GLuint vao;
			GLuint positionBuffer, normalsBuffer, indexBuffer;
			util::Shader *shader;
			glm::vec3 lightColor;
			glm::vec3 lightDir;
			//TODO: only do this if coordinates are hardcoded (don't do this)
			static const float positions[CUBE_VERTEX_COUNT * 3];
			static const float normals[CUBE_VERTEX_COUNT * 3];
			static const unsigned int indices[CUBE_INDEX_COUNT];

		};
	}
}