#include "Light.hpp"
#include <glm/glm.hpp>
#include <glm\gtc\matrix_transform.hpp>
#include <glm\gtc\type_ptr.hpp>

using namespace cgue;
using namespace cgue::scene;

Light::Light(glm::mat4& _modelMatrix, ObjectType _objectType, util::Shader* _shader)
:SceneObject(_modelMatrix, _objectType), shader(_shader), lightColor((1.0f, 1.0f, 1.0f)), lightDir((0.0f, -1.0f, 0.0f))	{

	radius = 0.8f;

	////load data to buffer, type of buffer gets defined after first binding
	//glGenBuffers(1, &positionBuffer);
	//glBindBuffer(GL_ARRAY_BUFFER, positionBuffer);
	//glBufferData(GL_ARRAY_BUFFER, CUBE_VERTEX_COUNT * 3 * sizeof(float), positions, GL_STATIC_DRAW);
	//glBindBuffer(GL_ARRAY_BUFFER, 0);	//0 = buffer unbind

	////index buffer
	//glGenBuffers(1, &indexBuffer);
	//glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, indexBuffer);
	//glBufferData(GL_ELEMENT_ARRAY_BUFFER, CUBE_INDEX_COUNT * sizeof(unsigned int), indices, GL_STATIC_DRAW);
	//glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);	//0 = buffer unbind

	////normal buffer
	//glGenBuffers(1, &normalsBuffer);
	//glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, normalsBuffer);
	//glBufferData(GL_ELEMENT_ARRAY_BUFFER, CUBE_VERTEX_COUNT * 3 * sizeof(float), normals, GL_STATIC_DRAW);
	//glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);	//0 = buffer unbind

	////generate bindings
	//glGenVertexArrays(1, &vao);
	//glBindVertexArray(vao);

	////binding position buffer
	//glBindBuffer(GL_ARRAY_BUFFER, positionBuffer);
	//GLint positionIndex = glGetAttribLocation(shader->programHandle, "position");
	//if (positionIndex != -1) {
	//	glEnableVertexAttribArray(positionIndex);
	//	glVertexAttribPointer(positionIndex, 3, GL_FLOAT, GL_FALSE, 0, 0);
	//}


	////binding normals buffer
	//glBindBuffer(GL_ARRAY_BUFFER, normalsBuffer);
	//GLint normalIndex = glGetAttribLocation(shader->programHandle, "normal");
	//if (normalIndex != -1) {
	//	glEnableVertexAttribArray(normalIndex);
	//	glVertexAttribPointer(normalIndex, 3, GL_FLOAT, GL_FALSE, 0, 0);
	//}

	//glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, indexBuffer);


	////unbind
	//glBindVertexArray(0);
	//glBindBuffer(GL_ARRAY_BUFFER, 0);
	//glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);
}

Light::~Light(){
	/*glDeleteBuffers(1, &positionBuffer);
	glDeleteBuffers(1, &normalsBuffer);
	glDeleteBuffers(1, &indexBuffer);
	glDeleteVertexArrays(1, &vao);*/
}

void Light::update(float time_delta) {
	// sun does not change
}

void Light::draw() {

	shader->useShader();

	/* lighting stuff */

	GLint lightColor_location = glGetUniformLocation(shader->programHandle, "lightColor");

	if (lightColor_location != -1){
		glUniform3f(lightColor_location, lightColor.r, lightColor.g, lightColor.b);	//set light Color
	}
	/**/
	auto model_location = glGetUniformLocation(shader->programHandle, "model");
	glUniformMatrix4fv(model_location, 1, GL_FALSE, glm::value_ptr(modelMatrix));
	/*
	glBindVertexArray(vao);
	glDrawElements(GL_TRIANGLES, CUBE_INDEX_COUNT, GL_UNSIGNED_INT, 0);
	glBindVertexArray(0);
	*/
}
void Light::drawCustomShader(util::Shader* customshader) {
	util::Shader* tmp = shader;
	shader = customshader;

	draw();
	shader = tmp;
}
void Light::setColor(glm::vec3 _lightColor) {
	lightColor = _lightColor;
}
glm::vec3 Light::getLightColor() {
	return lightColor;
}

glm::vec3 Light::getLightPos() {
	return SceneObject::position();
}

void Light::setLightDir(glm::vec3 _lightDir) {
	lightDir = _lightDir;
}

glm::vec3 Light::getLightDir() {
	return lightDir;
}


//positions with normals
const float Light::positions[CUBE_VERTEX_COUNT * 3] = {

	//back
	-0.5f, -0.5f, -0.5f,
	-0.5f, 0.5f, -0.5f,
	0.5f, 0.5f, -0.5f,
	0.5f, -0.5f, -0.5f,

	//front
	-0.5f, -0.5f, 0.5f,
	0.5f, -0.5f, 0.5f,
	0.5f, 0.5f, 0.5f,
	-0.5f, 0.5f, 0.5f,

	//top
	0.5f, 0.5f, 0.5f,
	0.5f, 0.5f, -0.5f,
	-0.5f, 0.5f, -0.5f,
	-0.5f, 0.5f, 0.5f,

	//bottom
	0.5f, -0.5f, 0.5f,
	-0.5f, -0.5f, 0.5f,
	-0.5f, -0.5f, -0.5f,
	0.5f, -0.5f, -0.5f,

	//right
	0.5f, 0.5f, 0.5f,
	0.5f, -0.5f, 0.5f,
	0.5f, -0.5f, -0.5f,
	0.5f, 0.5f, -0.5f,

	//left

	-0.5f, 0.5f, 0.5f,
	-0.5f, 0.5f, -0.5f,
	-0.5f, -0.5f, -0.5f,
	-0.5f, -0.5f, 0.5f,

};

//new indices
const unsigned int Light::indices[CUBE_INDEX_COUNT] = {

	0, 1, 2,
	0, 2, 3,

	4, 5, 6,
	4, 6, 7,

	8, 9, 10,
	8, 10, 11,

	12, 13, 14,
	12, 14, 15,

	16, 17, 18,
	16, 18, 19,

	20, 21, 22,
	20, 22, 23
};

const float Light::normals[CUBE_VERTEX_COUNT * 3] = {
	0.0f, 0.0f, -1.0f,
	0.0f, 0.0f, -1.0f,
	0.0f, 0.0f, -1.0f,
	0.0f, 0.0f, -1.0f,

	0.0f, 0.0f, 1.0f,
	0.0f, 0.0f, 1.0f,
	0.0f, 0.0f, 1.0f,
	0.0f, 0.0f, 1.0f,

	0.0f, 1.0f, 0.0f,
	0.0f, 1.0f, 0.0f,
	0.0f, 1.0f, 0.0f,
	0.0f, 1.0f, 0.0f,

	0.0f, -1.0f, 0.0f,
	0.0f, -1.0f, 0.0f,
	0.0f, -1.0f, 0.0f,
	0.0f, -1.0f, 0.0f,

	1.0f, 0.0f, 0.0f,
	1.0f, 0.0f, 0.0f,
	1.0f, 0.0f, 0.0f,
	1.0f, 0.0f, 0.0f,

	-1.0f, 0.0f, 0.0f,
	-1.0f, 0.0f, 0.0f,
	-1.0f, 0.0f, 0.0f,
	-1.0f, 0.0f, 0.0f,

};


void Light::setSamplingQuality(int minQuality, int magQuality) {
	// does nothing here
}

void Light::changeNormalMapping() {
	// does nothing here
}
