/*//references:	http://www.videotutorialsrock.com/opengl_tutorial/terrain/text.php

*/

#pragma once
#include <iostream>
#include <vector>
#include <string>

#include <glm/glm.hpp>
#include <glm/gtc/matrix_transform.hpp>
#include <glm\gtc\type_ptr.hpp>
#include <GL/glew.h>
#include <GLFW/glfw3.h>
#include <assimp/Importer.hpp>
#include <assimp/scene.h>
#include <assimp/mesh.h>
#include <assimp/postprocess.h>
#include <FreeImage\FreeImage.h>

namespace cgue {
	namespace scene {

		class Heightmap {
		public:
			Heightmap(int width, int length);
			virtual ~Heightmap();

			int getWidth();
			int getLength();

			void setHeight(int x, int z, float y);
			float getHeight(int x, int z);

			Heightmap* loadHeightmap(const char* filename, float height);

		private:
			int width;
			int length;
			float** heights;




		};

	}
}