#include "Heightmap.hpp"


using namespace cgue;
using namespace cgue::scene;

Heightmap::Heightmap(int w, int l){
	width = w;
	length = l;
	heights = new float*[length];
	for (int i = 0; i < length; i++) {
		heights[i] = new float[width];
	}

}

Heightmap::~Heightmap() {
	for (int i = 0; i < length; i++) {
		delete[] heights[i];
	}
	delete[] heights;
}

int Heightmap::getWidth() {
	return width;
}
int Heightmap::getLength() {
	return length;
}

// Sets the height at (x,z) to y
void Heightmap::setHeight(int x, int z, float y) {
	heights[z][x] = y;
}

//Returns the height at (x,z)
float Heightmap::getHeight(int x, int z) {
	return heights[z][x];
}

//Loads the information from the heightmap
Heightmap* Heightmap::loadHeightmap(const char* filename, float height) {


	FIBITMAP* bitmap = FreeImage_Load(FreeImage_GetFileType(filename, 0), filename);
	FIBITMAP *pImage = FreeImage_ConvertTo32Bits(bitmap);
	int w = FreeImage_GetWidth(pImage);
	int h = FreeImage_GetHeight(pImage);

	Heightmap* hm = new Heightmap(w, h);
	for (int y = 0; y < h; y++) {
		for (int x = 0; x < width; x++) {
			RGBQUAD freeImageColor;
			FreeImage_GetPixelColor(bitmap, x, y, &freeImageColor);
			char r = freeImageColor.rgbRed; // [0,255]
			// [-height/2, height/2]
			float height_ = height * ((r / 255.0f) - 0.5f);
			hm->setHeight(x, y, height_);
		}
	}

	FreeImage_Unload(bitmap);
	FreeImage_Unload(pImage);

	return hm;
}

