//reference: http://learnopengl.com/#!Advanced-OpenGL/Framebuffers

#pragma once

#include <glm/glm.hpp>
#include <iostream>
#include "../Util/Shader.hpp"
#define QUAD_VERTEX_COUNT 24

namespace cgue {
	namespace scene {
		class FrameBufferQuad {
		public:
			FrameBufferQuad(util::Shader* _shader, int _screenWidth, int _sreenHeight);
			virtual ~FrameBufferQuad();

			void bind();
			void unbind();
			void draw();
			void unbindAndDraw();
			void activateTexture();
			void deactivateTexture();

		private:
			util::Shader* shader;
			int screenWidth, screenHeight;
			GLuint vao, vbo, fbo, rbo;
			GLuint texColBuffer;
			static const GLfloat quadVertices[QUAD_VERTEX_COUNT];

			void init();


		};
	}
}