#pragma once

#include <glm/glm.hpp>
#include <glm\gtc\matrix_transform.hpp>

#include "SceneObject.hpp"

namespace cgue {
	namespace scene {
		class Camera {
		public:
			Camera(SceneObject* _sceneObject);

			virtual ~Camera();

			virtual void update();

			void zoomIn();
			void zoomOut();

			void toggleHeroAttachment();
			void attachToHero();

			void rotateCameraHorizontal(const float& degree);
			void invertHorizontalRotation();

			glm::mat4 modelMatrix;
			SceneObject* sceneObject;

			glm::vec3 position();
			glm::vec3 pointsTo();
			glm::vec3 up();
			glm::vec3 left();
			glm::vec3 eyeDirection();
		private:
			float cameraDistance;
			float cameraRotationHorizontalDeg;
			glm::mat4 cameraRotation;
			bool attachedCamera;

			glm::mat4 inverseModel;

			float rotationLeft;
			float rotationTop;

			glm::mat4 heroRotation;
			glm::vec3 heroPosition;

			void updateFromHero();
		};
	}
}