#include <iostream>
#include <glm/glm.hpp>
#include <glm\gtc\matrix_transform.hpp>
#include <glm\gtc\type_ptr.hpp>
#include <glm\gtx\string_cast.hpp>

#include "Camera.hpp"

using namespace cgue::scene;

Camera::Camera(SceneObject* _sceneObject)
:sceneObject(_sceneObject)
{
	cameraDistance = 12.0f;
	cameraRotationHorizontalDeg = -20.0f;
	cameraRotation = glm::rotate(glm::mat4(1.0f), glm::radians(cameraRotationHorizontalDeg), glm::vec3(1, 0, 0));
	rotationLeft = 0.0f;
	rotationTop = 0.0f;

	attachedCamera = true;

	update();
}

Camera::~Camera(){
}

void Camera::update() {
	if (attachedCamera) {
		updateFromHero();
	}


	auto heroPositionMatrix = glm::translate(glm::mat4(1.0f), heroPosition);
	auto fakeHeroMatrix = heroPositionMatrix * heroRotation;


	glm::mat4 rotBehind = glm::rotate(glm::mat4(1.0f), glm::radians(180.0f), glm::vec3(0, 1, 0));

	glm::mat4 cameraInObjectSpace = fakeHeroMatrix * rotBehind * cameraRotation * glm::translate(glm::mat4(1.0f), glm::vec3(0.0f, 1.0f, cameraDistance));

	//auto campos = glm::vec3(0.0f, 2.0f, cameraDistanceInObjectSpace) + heroPos;

	//cameraPos = glm::vec3(cameraInObjectSpace[3].x, cameraInObjectSpace[3].y, cameraInObjectSpace[3].z);

	//modelMatrix = glm::lookAt(cameraPos, heroPos, glm::vec3(0, 1, 0));

	inverseModel = cameraInObjectSpace;
	modelMatrix = inverse(cameraInObjectSpace);
}

void Camera::zoomIn() {
	cameraDistance = cameraDistance - 2.0f;
}

void Camera::zoomOut() {
	cameraDistance = cameraDistance + 2.0f;
}

void Camera::updateFromHero() {
	auto heroMatrix = sceneObject->modelMatrix;
	heroPosition = glm::vec3(heroMatrix[3].x, heroMatrix[3].y, heroMatrix[3].z);
	heroRotation = sceneObject->rotationMatrix;
}

void Camera::toggleHeroAttachment() {
	if (attachedCamera) {
		attachedCamera = false;
	}
	else {
		attachedCamera = true;
	}
}

void Camera::attachToHero() {
	attachedCamera = true;
}


void Camera::rotateCameraHorizontal(const float& degree) {
	//if (attachedCamera) {
		cameraRotationHorizontalDeg += degree;
		cameraRotation = glm::rotate(glm::mat4(1.0f), glm::radians(cameraRotationHorizontalDeg), glm::vec3(1, 0, 0));
	//}
}

void Camera::invertHorizontalRotation() {
	rotateCameraHorizontal(-cameraRotationHorizontalDeg);
}


glm::vec3 Camera::position() {
	return glm::vec3(
		inverseModel[3].x,
		inverseModel[3].y,
		inverseModel[3].z);
}

glm::vec3 Camera::pointsTo() {
	return heroPosition;
}

glm::vec3 Camera::eyeDirection() {
	return position() - pointsTo();
}

glm::vec3 Camera::up() {
	auto mat_up = inverseModel * glm::translate(glm::mat4(1.0f), glm::vec3(0.0f, 1.0f, 0.0f));
	auto loc_up = glm::vec3(mat_up[3].x, mat_up[3].y, mat_up[3].z);

	auto up = loc_up - position();
	return glm::normalize(up);
}

glm::vec3 Camera::left() {
	auto mat_left = inverseModel * glm::translate(glm::mat4(1.0f), glm::vec3(-1.0f, 0.0f, 0.0f));
	auto loc_left = glm::vec3(mat_left[3].x, mat_left[3].y, mat_left[3].z);

	auto left = loc_left - position();
	return glm::normalize(left);
}