#include "WindowCreator.hpp"

using namespace cgue::loop;

WindowCreator::WindowCreator(int argc, char** argv) {
	//get height and width from command line
	width = 1024;
	height = 768;
	refresh_rate = 60;
	setFullscreen = false;

	if (argc >= 4) {

		if ((std::stringstream(argv[1]) >> width).fail()) {
			std::cout << "please use int for window width" << std::endl;
			system("PAUSE");
			exit(EXIT_FAILURE);
		}
		if ((std::stringstream(argv[2]) >> height).fail()) {
			std::cout << "please use int for window height" << std::endl;
			system("PAUSE");
			exit(EXIT_FAILURE);
		}
		if ((std::stringstream(argv[3]) >> refresh_rate).fail()) {
			std::cout << "please use int for refresh rate" << std::endl;
			system("PAUSE");
			exit(EXIT_FAILURE);
		}
		if (argc >= 5) {
			if (std::string(argv[4]) == "-f") {
				setFullscreen = true;
			}
		}
	}
}

WindowCreator::~WindowCreator() {
	glfwTerminate();
}

GLFWwindow* WindowCreator::create(DebugContext** debugContext) {
	//initialize GLFW
	if (!glfwInit()) {
		std::cout << "Failed to initialize GLFW" << std::endl;
		system("PAUSE");
		exit(EXIT_FAILURE);
	}

	//use openGL 3.3 and newer
	glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 3);
	glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 3);
	glfwWindowHint(GLFW_OPENGL_PROFILE, GLFW_OPENGL_CORE_PROFILE);

	*debugContext = new DebugContext();
	GLFWwindow* window = nullptr;

	if (setFullscreen) {
		glfwWindowHint(GLFW_REFRESH_RATE, refresh_rate);	//this seems to overwrite debugcontext
		GLFWmonitor* monitor = glfwGetPrimaryMonitor();
		window = glfwCreateWindow(width, height, "Summertime with Sir Lancelot", monitor, nullptr);
	}
	else {
		window = glfwCreateWindow(width, height, "Summertime with Sir Lancelot", nullptr, nullptr);
	}

	if (!window) {
		std::cout << "Failed to create window" << std::endl;
		glfwTerminate();
		system("PAUSE");
		exit(EXIT_FAILURE);
	}

	glfwMakeContextCurrent(window);

	//initialize GLEW
	glewExperimental = GL_TRUE;		//to load all the opengl extensions

	if (glewInit() != GLEW_OK) {
		std::cout << "Failed to initialize GLEW" << std::endl;
		system("PAUSE");
		exit(EXIT_FAILURE);
	}

	return window;
}
