#include "Toast.hpp"

using namespace cgue::loop;
using namespace cgue::scene;

#define TOAST_DURATION_SECONDS 3.0f

Toast::Toast(Text* _text) : text(_text) {
	time_left = 0;
}

void Toast::draw() {
	if (time_left > 0) {
		text->scale = 1.5f;
		float leftShift = message.length() * 0.5f * 0.025f; // per character 0.025 of screen length left
		text->draw(message, 0.45f - leftShift, 0.45f);
		text->scale = 1.0f;
	}
}

void Toast::update(double time_delta) {
	if (time_left > 0) {
		time_left -= time_delta;
	}
}

void Toast::notify(std::string _message) {
	message = _message;
	time_left = TOAST_DURATION_SECONDS;
}

