#pragma once
#include <string>
#include <vector>
#include <algorithm>
#include <irrKlang\irrKlang.h>

namespace cgue {
	namespace loop {
		class SoundHandler
		{
		public:
			SoundHandler();
			~SoundHandler();

			void playSound();
			void stopSound();
			void pause();
			void mute();
			void playGood();
			void playBad();
			void playMove();
			void playSplash();
			void playGameOver();
			void playGameWon();
			void playBonus();

		private:

			void init();
			bool isEffectPlaying();
			bool isMuted;

			irrklang::ISoundEngine* engineBackground;
			irrklang::ISoundEngine* engineEffects;
			std::string background;
			std::string goodSounds;
			std::string badSounds;
			std::string moveSounds;
			std::string splashSounds;
			std::string gameOverSounds;
			std::string gameWonSounds;
			std::string bonusSound;

			float volBackground, volEffects;
		};
	}
}