#include "SoundHandler.hpp"
#include <iostream>



using namespace cgue;
using namespace cgue::loop;
using namespace irrklang;
SoundHandler::SoundHandler()
:volEffects(0.6f), volBackground(0.2f) {

	background = "Media\\background.wav";

	goodSounds = "Media\\cat-scream.mp3";

	badSounds = "Media\\cat-meow.wav";

	moveSounds = "Media\\cat-grooming.wav";

	splashSounds = "Media\\splash.mp3";

	gameOverSounds = "Media\\gameOver.mp3";

	gameWonSounds = "Media\\cat-purring.wav";

	bonusSound = "Media\\bonus.mp3";

	init();
}
SoundHandler::~SoundHandler() {
	engineBackground->drop();
	engineEffects->drop();
	engineBackground = nullptr;
	engineEffects = nullptr;
}

void SoundHandler::init(){

	engineBackground = createIrrKlangDevice();
	engineEffects = createIrrKlangDevice();
	isMuted = false;
	if (!engineBackground || !engineEffects) {
		std::cout << "Error: Soundhandler" << std::endl;
	}
	engineBackground->setSoundVolume(volBackground);
	engineEffects->setSoundVolume(volEffects);
}

void SoundHandler::playSound() {
	engineBackground->play2D(background.c_str(), true);

}
void SoundHandler::stopSound() {
	engineBackground->stopAllSounds();
}
void SoundHandler::playBad() {
		engineEffects->play2D(badSounds.c_str());
}
void SoundHandler::playMove() {
	if (!isEffectPlaying()){
		engineEffects->play2D(moveSounds.c_str());
	}
}
void SoundHandler::playGood() {
	engineEffects->play2D(goodSounds.c_str());
}

void SoundHandler::playSplash() {
	engineEffects->play2D(splashSounds.c_str());
}

void SoundHandler::playGameOver() {
	engineBackground->stopAllSounds();
	engineEffects->play2D(gameOverSounds.c_str());
}

void SoundHandler::playGameWon() {
	engineBackground->stopAllSounds();
	engineEffects->play2D(gameWonSounds.c_str());
}

void SoundHandler::playBonus() {
	engineEffects->play2D(bonusSound.c_str());
}

void SoundHandler::mute() {
	if (!isMuted) {
		engineBackground->setSoundVolume(0);
		engineEffects->setSoundVolume(0);
		isMuted = true;
	}
	else {
		engineBackground->setSoundVolume(volBackground);
		engineEffects->setSoundVolume(volEffects);
		isMuted = false;
	}
}

bool SoundHandler::isEffectPlaying() {
	bool effectIsPlaying = false;
	
	if (engineEffects->isCurrentlyPlaying(goodSounds.c_str())) {
		effectIsPlaying = true;
	}
		
	if (engineEffects->isCurrentlyPlaying(badSounds.c_str())) {
		effectIsPlaying = true;
	}
	
	/*
	while (!effectIsPlaying && i < moveSounds.size()) {
	if (engineEffects->isCurrentlyPlaying(moveSounds.at(i).c_str()) ) {
	effectIsPlaying = true;
	}
	i++;
	}*/
	return effectIsPlaying;
}

