#include "Plane.hpp"

using namespace cgue::loop;

Plane::Plane() {
	n = glm::vec3(0.0f);
	d = 0.0f;
}

void Plane::setNormalAndPoint(glm::vec3 normal, glm::vec3 center) {
	n = normal;
	d = -glm::dot(n, center);
	normalize();
}

void Plane::normalize()
{
	float length = 1.0f / n.length();
	n *= length;
	d *= length;
}

float Plane::distance(glm::vec3 point){
	return glm::dot(n, point) + d;
}

glm::vec3 Plane::normal() {
	return n;
}


