#pragma once

#include <iostream>
#include <vector>
#include <glm\gtc\type_ptr.hpp>

#include "../Scene/SceneObject.hpp"
#include "../Scene/Camera.hpp"
#include "../Scene/SkyBox.hpp"
#include "../Scene/Text.hpp"
#include "../Scene/FrameBufferQuad.hpp"
#include "../Scene/ShadowMapBuffer.hpp"
#include "../Util/Shader.hpp"
#include "../Loader/ShaderLoader.hpp"
#include "../Loader/SceneObjectLoader.hpp"
#include "../Loader/TextureLoader.hpp"
#include "SoundHandler.hpp"
#include "Toast.hpp"
#include "GameLogic.hpp"
#include "HelpView.hpp"
#include "Frustum.hpp"


namespace cgue {
	namespace loop {
		
		enum TextureSamplingQuality{ TSQ_NEAREST_NEIGHBOR, TSQ_BILINEAR };
		enum MipMapQuality{ MMQ_OFF, MMQ_NEAREST_NEIGHBOR, MMQ_Linear };

		class LoopHelper
		{
		public:
			LoopHelper(GLFWwindow* window, SoundHandler* _soundhandler);
			virtual ~LoopHelper();

			GLFWwindow* window;

			void loop();
			void draw();
			void update(float time_delta);
			void startGame();
			void pauseGame();
			void unpauseGame();
			bool isGameStarted();

			loader::ShaderLoader* shaderLoader;
			loader::SceneObjectLoader* sceneObjectLoader;
			loader::TextureLoader* textureLoader;
			scene::Camera* camera;
			scene::SkyBox* skybox;
			scene::FrameBufferQuad *framebufferquad;
			scene::ShadowMapBuffer* depthbufferquad;
			scene::FrameBufferQuad* horizontalGlowBuffer;
			scene::FrameBufferQuad* verticalGlowBuffer;
			scene::FrameBufferQuad* objectBuffer;

			GameLogic* gameLogic;

			bool displayHelp;
			bool displayFrameTime;
			bool displayWireFrame;
			TextureSamplingQuality textureSamplingQuality;
			MipMapQuality mipMapQuality;
			bool viewFrustumCulling;
			bool transparency;

			Toast* toast;

		private:
			std::vector<scene::SceneObject*> currentSceneObjects;

			scene::Text* text;
			HelpView* helpView;
			Frustum* frustum;

			glm::tmat4x4<float, glm::highp> proj;
			glm::tmat4x4<float, glm::highp> view;
			glm::tmat4x4<float, glm::highp> view_proj;
			glm::mat4 lightSpaceMatrix;
			GLfloat far, near, aspect;

			void initializeProjection();
			void updateViewProjections();
			void calculateMatrices();
			void prepareCurrentSceneObjects();

			int getMinSampling();
			int getMagSampling();

			void renderGlow();
			void renderFPS();

			int fps;
			int width;
			int height;
			bool gameStarted;
			bool gamePause;

		};
	}
}