#pragma once

#include <iostream>
#include <vector>

#include "../Scene/SceneObject.hpp"
#include "../Scene/Camera.hpp"
#include "../Util/Shader.hpp"
#include "../Loader/ShaderLoader.hpp"
#include "../Loader/SceneObjectLoader.hpp"
#include "LoopHelper.hpp"
#include "SoundHandler.hpp"

namespace cgue {
	namespace loop {
		class InputHandler
		{
		public:
			InputHandler(GLFWwindow* _window, LoopHelper* _loopHelper, SoundHandler* _soundhandler);
			virtual ~InputHandler();

			void processKeyboardInput(float time_delta);
			bool isGameRunning();
			static bool gameRunning;

		private:
			GLFWwindow* window;
			static scene::Camera* camera;
			static loader::HeroParts* heroParts;
			static LoopHelper* loopHelper;
			static SoundHandler* soundhandler;

			bool fallingDown;
			bool jump;
			float startHeight;
			bool moveTailUp;

			double mouseX;
			double mouseY;
			int widthHalf;
			int heightHalf;

			void registerCallbacks();
			void getRotationFromMouse(float time_delta);
			void translateHeroParts(glm::vec3 trans);
			void rotateHeroParts(scene::Direction dir, float angle);
			void moveTail(float translationSpeed);

			static void mouseScrollCallback(GLFWwindow* window, double xoffset, double yoffset);
			static void keyCallback(GLFWwindow* window, int key, int scancode, int action, int mode);

			bool heroInBoundingBox();

		};
	}
}