#pragma once

#include <glm/glm.hpp>
#include <vector>
#include "../Loader/SceneObjectLoader.hpp"
#include "../Scene/SceneObject.hpp"
#include "../Scene/Text.hpp"
#include "SoundHandler.hpp"

namespace cgue {
	namespace loop {
		class GameLogic {
		public:
			GameLogic(loader::SceneObjectLoader* sceneObjectLoader, scene::Text* _text, SoundHandler* _soundhandler);
			void draw();
			void update(double time_delta);
			bool isGameOver();
			bool isGameWon();
			bool isOnPath();
			scene::SceneObject* getCurrentPathObject();
			void resetGame();

		private:
			scene::Text* text;
			loader::SceneObjectLoader* sceneObjectLoader;
			SoundHandler* soundHandler;
			
			double timeInSeconds;
			int miceLeft;
			int lifeLeft;
			int fps;
			bool onPath;
			bool inWater;
			glm::vec3 heroStartPos;
			scene::SceneObject* currentPathObj;

			void processHit(scene::SceneObject* sceneObject);
		};
	}
}