#pragma once
// source: http://www.lighthouse3d.com/tutorials/view-frustum-culling/

#include <glm/glm.hpp>
#include "Plane.hpp"
#include "../Scene/SceneObject.hpp"

namespace cgue {
	namespace loop {
		class Frustum {
		public:

			static enum { OUTSIDE, INTERSECT, INSIDE };
			Plane* pl[6];
			//glm::vec3 ntl, ntr, nbl, nbr, ftl, ftr, fbl, fbr;
			float nearD, farD, ratio, angle, tang;
			float nw, nh, fw, fh;

			Frustum();
			virtual ~Frustum();
			void setCamInternals(float angle, float ratio, float nearD, float farD);
			void setCamDef(glm::vec3 &p, glm::vec3 &l, glm::vec3 &up);

			int inFrustum(scene::SceneObject* sceneObject);
			float getWidth();
			float getHeight();
			float getNear();
			float getFar();

		private:
			enum {
				TOP = 0, BOTTOM, LEFT,
				RIGHT, NEARP, FARP
			};
		};
	}
}