#pragma once

#include <iostream>
#include <sstream>
#include <vector>

#include <GL\glew.h>
#include "../Util/Shader.hpp"

namespace cgue {
	namespace loop {

		class DebugContext {

		public:
			DebugContext();
			static std::string FormatDebugOutput(GLenum source, GLenum type, GLuint id, GLenum severity, const char* msg);

			static void APIENTRY DebugContext::DebugCallback(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar* message, const GLvoid* userParam);
			static void APIENTRY DebugContext::DebugCallbackAMD(GLuint id, GLenum category, GLenum severity, GLsizei length, const GLchar* message, GLvoid* userParam);
			void registerDebugCallback();
		private:
			//void registerDebugCallback();
		};
	}
}