#include "TextureLoader.hpp"

using namespace cgue::loader;

TextureLoader::TextureLoader() {

}


TextureLoader::~TextureLoader() {
	
}


GLuint TextureLoader::loadTexture(std::string name) {
	

	//Generate texture ID and load texture data 
	std::string path = "Models\\texture\\" + name;

	int width, height;
	FIBITMAP* bitmap = FreeImage_Load(FreeImage_GetFileType(path.c_str(), 0), path.c_str());


	FIBITMAP *pImage = FreeImage_ConvertTo32Bits(bitmap);
	FreeImage_Unload(bitmap);

	width = FreeImage_GetWidth(pImage);
	height = FreeImage_GetHeight(pImage);

	GLuint textureID;
	glGenTextures(1, &textureID);
	// Assign texture to ID
	glBindTexture(GL_TEXTURE_2D, textureID);
	//duck colors are correct in irfanview when rgb->bgr 
	//for duck: use second color scheme GL_BGRA leave swizle parameter in shader to .rgb or use GL_BRGB and change swizzle to .bgr
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, (void*)FreeImage_GetBits(pImage));
	//glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, width, height, 0, GL_BGRA, GL_UNSIGNED_BYTE, (void*)FreeImage_GetBits(pImage));
	glGenerateMipmap(GL_TEXTURE_2D);

	// Parameters
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	//unbind

	glBindTexture(GL_TEXTURE_2D, 0);
	FreeImage_Unload(pImage);

	return textureID;
};