#pragma once

#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <ctime>
#include <cstdlib>

#include "ShaderLoader.hpp"
#include "../Scene/SceneObject.hpp"
#include "../Scene/SkyBox.hpp"
#include "../Scene/Model.hpp"

namespace cgue {
	namespace loader {
		class Spawner
		{
		public:
			Spawner(ShaderLoader* _shaderLoader);

			std::vector<scene::Model*> getObjects();
			scene::SceneObject* getStartObject();
			const int getNumGood();

		private:
			std::vector<scene::Model*> objects;
			std::vector<scene::SceneObject*> pathObjects;
			std::vector<glm::vec3> poolPathObjectPositions;
			ShaderLoader* shaderLoader;

			void spawnPoisonMouseAt(glm::vec3 position);
			void spawnMouseAt(glm::vec3 position);
			void spawnBigBallAt(glm::vec3 position);
			void spawnSmallBallAt(glm::vec3 position);
			void spawnLifePreserverAt(glm::vec3 position);
			void spawnDuckAt(glm::vec3 position);
			void spawnHeartAt(glm::vec3 position);
			void spawnClockAt(glm::vec3 position);

			void spawnObjects();
			void spawnFurniture();
			void spawnObject(scene::ObjectType objectType);

			bool inHeroCube(glm::vec3 pos);
			bool collision(glm::vec3 pos);

			float random(float min, float max);
			glm::vec3 randomInPool();
			glm::vec3 onPoolPathObject();
			int vectorPosition;
			glm::vec3 duckHeadPos;
		};
	}
}

