#include "ShaderLoader.hpp"

using namespace cgue::loader;
using namespace cgue::util;
using namespace std;

ShaderLoader::ShaderLoader()
{
	
	loadShader("BasicTexture");

	loadShader("SkyBox");
	loadShader("EnvironmentalMap");
	loadShader("LampLighting");

	loadShader("FrameBufferScreen");
	loadShader("HorizontalGlowBufferScreen");
	loadShader("VerticalGlowBufferScreen");

	loadShader("Font");

	// shadow mapping
	loadShader("DepthBufferDebug");
	loadShader("SimpleDepthShader");
	loadShader("Shadow");
	loadShader("NormalMap");
	loadShader("NormalMapGreen");

	loadShader("Water");
	loadShader("DiffuseNormalMap");
	loadShader("DiffuseMaterial");

}


ShaderLoader::~ShaderLoader()
{
	for (auto x : shaders) {
		delete x.second; x.second = nullptr;
	}
}

void ShaderLoader::loadShader(string name) {
	auto shaderName = "Shader\\" + name;
	Shader *shader = new Shader(shaderName + ".vert", shaderName + ".frag");
	shaders.insert(pair<string, Shader*>(name, shader));
}

Shader* ShaderLoader::get(string name) {
	return shaders.at(name);
}