#pragma once

#include <iostream>
#include <string>
#include <vector>
#include <algorithm>

#include "ShaderLoader.hpp"
#include "../Scene/SceneObject.hpp"
#include "../Scene/SkyBox.hpp"
#include "../Scene/Mesh.hpp"
#include "../Scene/Model.hpp"
#include "../Scene/Light.hpp"
#include "Spawner.hpp"

namespace cgue {
	namespace loader {
		
		struct HeroParts {
			scene::SceneObject* heroBody;
			scene::SceneObject* heroTail;
			glm::vec3 tailBodyDifference;
			float tailAngle;
		};

		class SceneObjectLoader
		{
		public:
			SceneObjectLoader(ShaderLoader* _shaderLoader, scene::SkyBox* _skyBox);
			~SceneObjectLoader();

			scene::SceneObject* get(int);
			void remove(scene::SceneObject* sceneObject);

			scene::Light* getLight();
			scene::SceneObject* getStartPathObject();
			HeroParts* getHeroParts();
			const std::vector<scene::SceneObject*> getSceneObjects();
			const int getNumGood();
			void resetObjects();
			
		private:
			ShaderLoader* shaderLoader;
			Spawner *spawner;
			HeroParts* heroParts;
			scene::Light* sun;
			std::vector<scene::SceneObject*> sceneObjects;
			std::vector<scene::SceneObject*> backUpObjects;

			void spawnHero();
			void spawnLights();
		};
	}
}

