#include "SceneObjectLoader.hpp"

#include "../Scene/Mesh.hpp"
#include "../Scene/Model.hpp"
#include "../Scene/Light.hpp"
#include <algorithm>

using namespace cgue::loader;
using namespace cgue::scene;
using namespace std;

SceneObjectLoader::SceneObjectLoader(ShaderLoader* _shaderLoader, SkyBox* _skyBox)
:shaderLoader(_shaderLoader)
{
	spawnLights();

	// Pool
	Model *pool = new Model(glm::mat4(1.0f), ObjectType::ENVIRONMENT, shaderLoader->get("Shadow"), "Models//environment//pool//pool.obj");
	pool->translate(glm::vec3(0.0f, 2.0f, 0.0f));
	pool->setLight(sun);
	pool->radius = 100000000;
	sceneObjects.push_back(pool);

	Model *environment = new Model(glm::mat4(1.0f), ObjectType::ENVIRONMENT, shaderLoader->get("DiffuseNormalMap"), "Models//environment//pool//environment.obj");
	environment->translate(glm::vec3(0.0f, 2.0f, 0.0f));
	environment->setLight(sun);
	environment->height = 1.0f;
	environment->radius = 100.0f;
	sceneObjects.push_back(environment);


	// Palm trees
	Model *palm;

	// left
	float start = -40.0f;
	for (int i = 0; i < 7; i++) {
		palm = new Model(glm::mat4(1.0f), ObjectType::PATH, shaderLoader->get("Shadow"), "Models//environment//palm//palm.obj");
		palm->translate(glm::vec3(32.0f, 0.0f, start + (i*15.0f)));
		palm->rotate(Direction::LEFT, 180.0f);
		palm->radius = 0.5f;
		palm->height = 30.0f;
		palm->setLight(sun);
		sceneObjects.push_back(palm);
	}

	// right
	for (int i = 0; i < 7; i++) {
		palm = new Model(glm::mat4(1.0f), ObjectType::PATH, shaderLoader->get("Shadow"), "Models//environment//palm//palm.obj");
		palm->translate(glm::vec3(-32.0f, 0.0f, start + (i*15.0f)));
		palm->radius = 0.5f;
		palm->height = 30.0f;
		palm->setLight(sun);
		sceneObjects.push_back(palm);
	}

	
	// PoolPathObjects, Mice, PoisonMice,... , sceneObjects
	spawner = new Spawner(_shaderLoader);

	for (auto object : spawner->getObjects()) {
		object->setLight(sun);
		sceneObjects.push_back(object);
	}

	// Water, sceneObjects
	Model *water = new Model(glm::mat4(1.0f), ObjectType::ENVIRONMENT, shaderLoader->get("Water"), "Models//environment//water//water.obj");
	water->translate(glm::vec3(0.0f, 0.0f, 0.0f));
	water->scale(glm::vec3(25.0f, 25.0f, 25.0f));
	water->setLight(sun);
	water->radius = 100000000; // this object should not be culled!
	sceneObjects.push_back(water);

	// Cat, sceneObjects
	spawnHero();

	// save back up
	backUpObjects = sceneObjects;
}

void SceneObjectLoader::resetObjects() {

	// reset mice, bonus
	sceneObjects = backUpObjects;

	// reset hero
	glm::mat4 heroMatrix = heroParts->heroBody->modelMatrix;
	glm::mat4 rotationMatrix = heroParts->heroBody->rotationMatrix;

	heroParts->heroBody->modelMatrix = heroMatrix * glm::inverse(heroMatrix);
	heroParts->heroBody->rotationMatrix = rotationMatrix * glm::inverse(rotationMatrix);
	heroParts->heroBody->translate(glm::vec3(0.0f, 2.5f, 0.0f));
	heroParts->heroBody->scale(glm::vec3(3.0f));
	heroParts->heroTail->modelMatrix = heroParts->heroBody->modelMatrix;

}



SceneObjectLoader::~SceneObjectLoader()
{
	delete spawner; spawner = nullptr;

	for (auto object : sceneObjects) {
		delete object; object = nullptr;
	}
}


SceneObject* SceneObjectLoader::get(int pos) {
	return sceneObjects.at(pos);
}


void SceneObjectLoader::remove(SceneObject* sceneObject) {
	sceneObjects.erase(std::remove(sceneObjects.begin(), sceneObjects.end(), sceneObject), sceneObjects.end());
}


Light* SceneObjectLoader::getLight(){
	return sun;
}

HeroParts* SceneObjectLoader::getHeroParts(){
	return heroParts;
}

const std::vector<SceneObject*> SceneObjectLoader::getSceneObjects() {
	return sceneObjects;
}

SceneObject* SceneObjectLoader::getStartPathObject() {
	return spawner->getStartObject();
}

const int SceneObjectLoader::getNumGood() {
	return spawner->getNumGood();
}

void SceneObjectLoader::spawnHero() {
	heroParts = new HeroParts();

	// Cat
	// Model does not have normal map!!!
	Model *body = new Model(glm::mat4(1.0f), ObjectType::HERO, shaderLoader->get("DiffuseNormalMap"), "Models//cat//body.obj"); // "Models//hero//Cat//cat//cat.obj"
	body->translate(glm::vec3(0.0f, 2.5f, 0.0f));
	body->scale(glm::vec3(3.0f));
	body->setLight(sun);
	body->radius = 1.5f;
	body->height = 0.4f;
	
	sceneObjects.push_back(body);
	heroParts->heroBody = body;

	// Tail
	Model *tail = new Model(glm::mat4(1.0f), ObjectType::HERO, shaderLoader->get("DiffuseNormalMap"), "Models//cat//tail.obj");
	tail->setLight(sun);
	tail->modelMatrix = heroParts->heroBody->modelMatrix;
	tail->radius = 0.2f;

	sceneObjects.push_back(tail);
	heroParts->heroTail = tail;
	heroParts->tailBodyDifference = glm::vec3(0.0f);
	heroParts->tailAngle = 0;
	

}


void SceneObjectLoader::spawnLights() {
	sun = new Light(glm::mat4(1.0f), ObjectType::ENVIRONMENT, shaderLoader->get("LampLighting"));
	sun->setColor(glm::vec3(1.0f, 1.0f, 1.0f));
	sun->translate(glm::vec3(-20.0f, 30.0f, 15.0f));
}

// helper method that prints a point to a spawnDebugAt to stdout
void vec_to_debug(glm::vec3 vec) {
	std::cout << "spawnDebugAt(glm::vec3(" << std::to_string(vec.x) << "f, " << std::to_string(vec.y) << "f, " << std::to_string(vec.z) << "f));" << std::endl;
}