// source: http://www.gamasutra.com/blogs/RobertBasler/20131122/205462/Three_Normal_Mapping_Techniques_Explained_For_the_Mathematically_Uninclined.php?print=1

#version 330 core

struct Material {
	sampler2D texture_diffuse1;
	sampler2D texture_specular1;
	sampler2D texture_normal1;
	float shininess;
};

struct Light {
    vec3 position;
    vec3 ambient;
    vec3 diffuse;
    vec3 specular;
};

in vec3 Normal;
in vec2 TexCoords;
in vec3 FragPos;
in mat3 TBN;

out vec4 fragColor;

uniform Material material;
uniform Light light;
uniform samplerCube skybox;
uniform vec3 cameraPos;
uniform bool normalMapping;
uniform float time;


void main()
{           
	
	vec2 uv = TexCoords + 0.005 * vec2( sin( (time*0.2) + 100.0*TexCoords.x), cos( (time*0.2) + 100.0*TexCoords.y));

	vec3 normal = normalize(Normal);	
	vec3 viewDir = normalize(cameraPos - FragPos); // = vector points to view position
	vec3 lightDir = normalize(light.position - FragPos);
	
	if (normalMapping) {
		// obtain normal from normal map in range [0,1], 
		normal = texture(material.texture_normal1, uv).gbr; 
		normal = TBN * normalize(normal * 2.0 - 1.0);  // transform normal vector from range [0,1] to [-1,1]
	}
	
	
	// fresnel term 
	//float eta = 1/1.3f; // specifies the ratio of indices of refraction (water's index of refraction is 1.3)
	float fresnelbias = 0.2f; // ((1.0 - eta) * (1.0 - eta)) / ((1.0 + eta) * (1.0 + eta));
	float fresnelpower = 5.0f;
	
	// halfway vector h = (v + l) / |v + l|
	vec3 h = normalize(viewDir + lightDir);
	float lambertian = max(dot(normal, lightDir), 0.0);
	float fresnel = fresnelbias + (1.0 - fresnelbias) * pow((1.0 - dot(h,viewDir)),fresnelpower);
	
	// refraction
	vec3 waterColor = texture(material.texture_diffuse1, uv).bgr; // vec3(0.32, 0.8, 0.8);
	vec3 ambient = light.ambient * waterColor;
	vec3 diffuse = light.diffuse * lambertian * waterColor;
	
	// reflection
	vec3 specular = vec3(0.0);
	
	if (lambertian > 0.0) {
		//reflection
		vec3 reflectDir = normalize(reflect(-lightDir, normal));
		vec4 reflectColor = texture(skybox, reflectDir);
		float specAngle = max(dot(reflectDir, viewDir), 0.0); // max(dot(h, normal), 0.0);
		float spec = pow(specAngle, material.shininess);
		specular = light.specular * spec * vec3(reflectColor);
	}	
    
	// mix: linearly interpolate between refract- and reflectcolor
	// clamp: constrain fresnel to lie between 0 and 1
	fragColor = mix( vec4(ambient+diffuse, 0.8), vec4(specular,1.0), clamp( fresnel, 0.0, 1.0 ) ); 
	
}
