//reference: http://learnopengl.com/#!Advanced-OpenGL/Shadows/Shadow-Mapping
#version 330 core
layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;
layout (location = 3) in vec3 tangent;

out vec2 TexCoords;
out vec3 FragPos;
out vec3 Normal;
out vec4 FragPosLightSpace;
out mat3 TBN;

uniform mat4 lightSpaceMatrix;
uniform mat4 model;
uniform mat4 view_proj;
uniform mat4 t_i_model;


void main()
{
	gl_Position = view_proj * model * vec4(position,1.0f); 
	FragPos = vec3(model * vec4(position, 1.0f));
	TexCoords = texCoords;
	Normal = mat3(t_i_model) * normal;
	
	FragPosLightSpace = lightSpaceMatrix * vec4(FragPos, 1.0f);
    
	vec3 N = normalize( ( model * vec4( normal, 0.0 ) ).xyz );
	vec3 T = normalize( ( model * vec4( tangent.xyz, 0.0 ) ).xyz );
	vec3 B = normalize( ( model * vec4( ( cross( normal, tangent.xyz ) ), 0.0 ) ).xyz );
	
	TBN = mat3(T, B, N); // converts from Tangent Space to World Space
	
}