#version 330 core
uniform sampler2D screenTexture;

in vec2 TexCoords;

out vec4 color;

uniform float gauss[11] = float[](0.000001, 0.000088, 0.002289, 0.023204, 
	0.092564, 0.146632, 0.092564, 0.023204, 0.002289, 0.000088, 0.000001);

uniform float width;
uniform float height;
	
void main(void)
{
	vec4 sum = vec4( 0.0f );
	int i = 0;
	
	for(i = 0; i < 11; i++) {	
		vec2 offset = vec2((float(i)-6.0f)/float(width/2.0f), 0.0f);
	
		sum += texture2D( screenTexture, TexCoords + offset ) * gauss[i];
	}
	
	color = sum * 1.2f;
}