#version 330 core
// http://horde3d.org/wiki/index.php5?title=Shading_Technique_-_Fresnel

struct Material {
	sampler2D texture_diffuse1;
	sampler2D texture_specular1;
	float shininess;
};

struct Light {
    vec3 position;
    vec3 ambient;
    vec3 diffuse;
    vec3 specular;
};

in vec3 FragPos;
in vec3 Normal;
in vec2 TexCoords;

out vec4 fragColor;

uniform mat4 view;
uniform vec3 cameraPos;
uniform samplerCube skybox;
uniform Light light;
uniform Material material;


void main()
{

	//reflection
	// vec3 I = normalize(FragPos - cameraPos);
    // vec3 R = reflect(I, normalize(Normal));
    // fragColor = vec4(vec3(texture(skybox, R)), 1.0f);
	

	vec3 normal = normalize(Normal);
	vec3 viewPos = vec3(view[3].x, view[3].y, view[3].z); // = cameraPos
	vec3 viewDir = normalize(viewPos - FragPos); 			// points to camera
	vec3 lightDir = normalize(light.position - FragPos); 	// points to light

	
	// ambient
	vec3 ambient = light.ambient * vec3(texture(material.texture_diffuse1, TexCoords));
	
	// diffuse
	float lambertian = max(dot(normal, lightDir), 0.0);
	vec3 diffuse = light.diffuse * lambertian * vec3(texture(material.texture_diffuse1, TexCoords));
	
	// specular
	vec3 specular = vec3(0.0);
	
	if (lambertian > 0.0) {// light source on the right side
		vec3 reflectDir = reflect(-viewDir, normal);  
		vec4 reflectColor = texture(skybox, reflectDir);
		specular = light.specular * vec3(reflectColor);
		//float specAngle = max(dot(reflectDir, viewDir), 0.0);
		//float spec = pow(specAngle, material.shininess);
		//specular = light.specular * spec * vec3(reflectColor);
	}
	
	// fresnel term
	//float eta = 1/1.5f; // (1/reflective index) : water = 1.3, glass = 1.5, diamond = 1.8
	float fresnelBias = 0.2f; // ((1.0 - eta) * (1.0 - eta)) / ((1.0 + eta) * (1.0 + eta));
	float fresnelPower = 5.0f;
	vec3 H = normalize(viewDir + lightDir); // halfway vector H = (V + L) / |V + L|
	float fresnel = fresnelBias + (1.0 - fresnelBias) * pow((1.0 - dot(H,viewDir)), fresnelPower);

	vec3 result = mix( ambient+diffuse, specular, clamp( fresnel, 0.0, 1.0 ) ); 
	fragColor = vec4(result.bgr,1.0f);

}
	
	