#version 330 core
/*reference: 
	//http://www.learnopengl.com/#!Model-Loading/Model 
	//cgue tutorial
*/
layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;

out vec3 FragPos;
out vec2 TexCoords;
out vec3 Normal;

uniform mat4 model;
uniform mat4 t_i_model;
uniform mat4 view_proj;
//uniform mat4 projection;

void main()
{
    gl_Position = view_proj * model * vec4(position, 1.0f);
	FragPos = vec3(model * vec4(position, 1.0f));
    TexCoords = texCoords;
	Normal = mat3(t_i_model) * normal;
}