#version 330 core
/*reference: 
	//http://www.learnopengl.com/#!Model-Loading/Model 
	//cgue tutorial
*/
struct Material {
	sampler2D texture_diffuse1;
	sampler2D texture_specular1;
	float shininess;
};

struct Light {
    vec3 position;
    vec3 ambient;
    vec3 diffuse;
    vec3 specular;
};

in vec3 Normal;
in vec3 FragPos;
in vec2 TexCoords;

out vec4 fragColor;
uniform mat4 view;
uniform vec3 viewPos;
uniform Material material;
uniform Light light;

void main()
{    
	vec3 viewPos2 = vec3(view[3].x, view[3].y, view[3].z);
	vec3 ambient = light.ambient * vec3(texture(material.texture_diffuse1, TexCoords));
	
	vec3 viewDir = normalize(viewPos2 - FragPos);
	vec3 norm = normalize(Normal);
	vec3 lightDir = normalize(light.position - FragPos);
	
	float diff = max(dot(norm, lightDir), 0.0);	
	vec3 diffuse = light.diffuse * diff * vec3(texture(material.texture_diffuse1, TexCoords));
	
	vec3 reflectDir = reflect(-lightDir, norm);  
    float spec = pow(max(dot(viewDir, reflectDir), 0.0), material.shininess);
	vec3 specular = light.specular * spec * vec3(texture(material.texture_specular1, TexCoords));
	
	//attenuation?
	//duck needs bgr or GL_BGR in model.cpp
	vec3 result = (ambient + diffuse + specular);
	fragColor = vec4(result.bgr,1.0f);
	
    //fragColor = vec4(texture(texture_diffuse1, TexCoords).bgr,1.0);
	//fragColor = vec4(texture(texture_diffuse1, TexCoords).rgb,1.0);
	
}