#version 330 core

in vec3 fragmentUV;

layout(location=0) out vec4 fragColor;
layout(location=1) out vec4 brightColor;

uniform samplerCube skybox;

uniform bool celShading;

void main()
{
	vec3 textureColor = texture(skybox, fragmentUV).rgb;

	float brightness = dot(textureColor.rgb, vec3(0.2126, 0.7152, 0.0722)); // extract the brightness from the texture (grayscale) 
 
	float shadeIntensity; 
	if (false && celShading) {
		shadeIntensity = ceil(brightness * 5) / 5; 
		fragColor = vec4(textureColor / brightness * shadeIntensity, 1.0); 
	} else {
		shadeIntensity = brightness; 
		fragColor = vec4(textureColor, 1.0); 
	} 

	if (shadeIntensity > 0.9) {
		brightColor = vec4(fragColor.rgb, 1.0);
	} else {
		brightColor = vec4(0, 0, 0, 1);
	}
}