#version 330 core

layout(location = 0) in vec3 vertex;
layout(location = 1) in vec4 xyzs;   // xyz positions + s size
layout(location = 2) in vec4 color;  // r, g, b, a

out vec2 vertUv;
out vec4 vertColor;

uniform vec3 CameraRight_worldspace;
uniform vec3 CameraUp_worldspace;
uniform mat4 view_projection;

void main()
{
	float size = xyzs.w;
	vec3 particleCenter_worldspace = xyzs.xyz;
	
	vec3 vertexPosition_worldspace = particleCenter_worldspace + CameraRight_worldspace * vertex.x * size + CameraUp_worldspace * vertex.y * size;

	gl_Position = view_projection * vec4(vertexPosition_worldspace, 1.0f);

	vertUv = vertex.xy + vec2(0.5, 0.5);
	vertColor = color;
}