#version 330 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec3 aTangent;
layout(location = 3) in vec3 aBitangent; // not necessary
layout(location = 4) in vec2 uv;

out VS_OUT {
	vec3 fragmentPosition;
	vec3 fragmentNormal;
	vec2 fragmentUV;
	mat3 TBN;
} vs_out;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main()
{
    vs_out.fragmentPosition = vec3(model * vec4(position, 1.0));   
	vs_out.fragmentNormal = (model * vec4(normal, 0)).xyz;
    vs_out.fragmentUV = uv;
    
    vec3 T = normalize(vec3(model * vec4(aTangent, 0.0f)));
    vec3 N = normalize(vec3(model * vec4(normal, 0.0f)));
    vec3 B = normalize(vec3(model * vec4(aBitangent, 0.0f)));
    T = normalize(T - dot(T, N) * N);

    vs_out.TBN = mat3(T, B, N);
        
	gl_Position = projection * view * model * vec4(position, 1.0);
}